<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="this is a demo meta description">
    <meta name="keywords" content="this is a demo meta keywords">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo/icon.png')); ?>" type="image/x-icon">
    <title><?php echo e($gnl->title); ?> | <?php echo e($gnl->subtitle); ?> </title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/animate.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.4.0.0.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/global/plugins/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/slicknav.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/owl.carousel.min.2.2.1.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/responsive.css')); ?>">
    <script src="<?php echo e(asset('assets/front/js/jquery-2.2.4.min.js')); ?>"></script>
     <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
      <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
</head>

</head>
<body>
    <!--navbar area start-->
    <nav class="navbar-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-8">
                    <a href="<?php echo e(url('/')); ?>" class="logo"><img src="<?php echo e(asset('assets/images/logo/logo.png')); ?>" alt="logo image"></a>
                </div>
                <div class="col-lg-9 col-md-6 col-sm-4">
                    <div class="responsive-menu-wrapper"></div>
                    <ul id="main-menu" class="text-right">
                        <?php if(auth()->guard()->check()): ?>
                        <li><a href="<?php echo e(route('home')); ?>"><?php echo e(Auth::user()->name); ?></a></li>
                         <li>
                            <a href="<?php echo e(route('logout')); ?>"
                            onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();"><i class="fa fa-sign-out" aria-hidden="true"></i>
                            <span>SIGN OUT</span>
                          </a>

                          <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                          </form>
                        </li>
                        <?php else: ?>
                        <li><a href="<?php echo e(route('login')); ?>">Sign In</a></li>
                        <li><a href="<?php echo e(route('register')); ?>">Sign Up</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!--navbar area end-->
<?php if(session('success')): ?>
<script type="text/javascript">
        $(document).ready(function(){
            swal("Success!", "<?php echo e(session('success')); ?>", "success");
        });
</script>
<?php endif; ?>

<?php if(session('alert')): ?>
<script type="text/javascript">
        $(document).ready(function(){
            swal("Sorry!", "<?php echo e(session('alert')); ?>", "error");
        });
</script>
<?php endif; ?>
<section class="subscription-section subscription-bg" id="subscribe" style="background-image: url(<?php echo e(asset('assets/images/section')); ?>/<?php echo e($front->secbg4); ?>);">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="subscription-form">
                    <form class="form-inline" method="POST" action="<?php echo e(route('search.wallet')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <input type="text" name="wallet"  class="form-control mb-2 mr-sm-2 mb-sm-0"  value="<?php echo e($qry); ?>" required>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i> Seacrch</button>
                    </form>
                </div>
                <hr/>
            </div>
        </div>
        <div class="row text-center">
            <div class="col-lg-10 col-md-10 col-sm-10 ml-auto mr-auto" >
                    <?php $__currentLoopData = $trans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       <div class="card">
                          <div class="card-header">Transaction Amount: <strong><?php echo e($tn->amount); ?> </strong><?php echo e($gnl->cur); ?></div>
                          <div class="card-body">
                            <ul class="list-group">
                              <li class="list-group-item">Receiver Wallet: <strong <?php if($qry==$tn->receiver): ?> style="color: #ff6600;" <?php endif; ?>><?php echo e($tn->receiver); ?></strong></li>
                              <li class="list-group-item">Sender Wallet:  <strong <?php if($qry==$tn->sender): ?> style="color: #ff6600;" <?php endif; ?>><?php echo e($tn->sender); ?></strong></li>
                              <li class="list-group-item">Transaction ID: <strong <?php if($qry==$tn->trxid): ?> style="color: #ff6600;" <?php endif; ?>><?php echo e($tn->trxid); ?></strong></li>
                              <li class="list-group-item">Trx Time: <strong><?php echo e($tn->created_at); ?></strong></li>
                            </ul>
                          </div>
                        </div>
                        <hr/>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            </div>
        </div>
    </div>
</section>

<!--footer area start-->
<footer class="footer-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 text-center">
                <p>&COPY; <?php echo $front->footer1; ?></p>
            </div>
        </div>
    </div>
</footer>
<!--footer area end-->

<!--back to top start-->
<div class="back-to-top">
    <i class="fa fa-angle-up"></i>
</div>
<!--back to top end-->

    <!-- popper js -->
    <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
    <!-- bootstrap.4.0.0 js -->
    <script src="<?php echo e(asset('assets/front/js/bootstrap.4.0.0.min.js')); ?>"></script>
    <!-- wow js -->
    <script src="<?php echo e(asset('assets/front/js/wow.min.js')); ?>"></script>
    <!-- magnific-popup js -->
    <script src="<?php echo e(asset('assets/front/js/jquery.magnific-popup.min.js')); ?>"></script>
    <!-- slicknav js -->
    <script src="<?php echo e(asset('assets/front/js/jquery.slicknav.min.js')); ?>"></script>
    <!-- owl carousel 2.2.1 js -->
    <script src="<?php echo e(asset('assets/front/js/owl.carousel.min.2.2.1.js')); ?>"></script>
    <!-- rcountdown js -->
    <script src="<?php echo e(asset('assets/front/js/rcoundown.js')); ?>"></script>
    <!-- waypoint js -->
    <script src="<?php echo e(asset('assets/front/js/waypoints.min.js')); ?>"></script>
    <!-- waypoint js -->
    <script src="<?php echo e(asset('assets/front/js/jquery.counterup.min.js')); ?>"></script>
    <!-- main js -->
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
</body>
</html>
