<?php

namespace App\Http\Controllers;

use App\Address;
use App\Gateway;
use App\General;
use App\Price;
use App\Sell;
use App\Transaction;
use App\User;
use Auth;
use Session;
use Illuminate\Http\Request;

class SendController extends Controller
{
    public function send(Request $request)
    {
        $this->validate($request,
            [
                'amount' => 'required',
                'toadd' => 'required',
            ]);

            $gnl = General::first();
            //$uwallet = Address::find($request->fromad);
            $toadds = explode('?', $request->toadd);

            $towallet = Address::where('address', $toadds[0])->first();

            if (is_null($towallet)) {
                return back()->with('alert', 'Invalid Wallet Address');
            } else {
                if ($request->amount < 0) {
                    return back()->with('alert', 'Invalid Amount');
                } else {
                    //$total = $request->amount+($request->amount*$gnl->trancrg)/100;

                    //$uwallet['balance'] = $uwallet->balance-$total;
                    //$uwallet->save();

                    $towallet['balance'] = $towallet->balance + $request->amount;
                    $towallet->save();

                    $trans['receiver'] = $towallet->address;
                    $trans['rcid'] = $towallet->user_id;
                    $trans['sender'] = "AUTH00000000000000000000000000000000";
                    $trans['snid'] = "1";
                    $trans['amount'] = $request->amount;
                    $trans['trxid'] = str_random(32);
                    Transaction::create($trans);

                    Echo "Success";
                    die();
                }
            }
    }
    public function receive(Request $request)
    {
        $this->validate($request,
            [
                'amount' => 'required',
                'frmv' => 'required',
            ]);
        $gnl = General::first();
        //$uwallet = Address::find($request->fromad);
        $fdel = explode('?', $request->frmv);

        $frmwallet = Address::where('address',$fdel[0])->first();


        if(is_null($frmwallet))
        {
            echo"Invalid Wallet Address";die();
        }
        else
        {
            if ($request->amount<0 || $request->amount>$frmwallet->balance)
            {
                echo"Invalid Amount";die();
            }
            else
            {
                //$total = $request->amount+($request->amount*$gnl->trancrg)/100;

                //$uwallet['balance'] = $uwallet->balance-$total;
                //$uwallet->save();

                $frmwallet['balance'] = $frmwallet->balance-$request->amount;
                $frmwallet->save();

                $trans['receiver'] = "AUTHLjCLSYy5OyyAYPSEXxElFZXppTRkvZZ0";
                $trans['rcid'] = "1";
                $trans['sender'] = $frmwallet->address;
                $trans['snid'] = $frmwallet->user_id;
                $trans['amount'] = $request->amount;
                $trans['trxid'] = str_random(32);
                Transaction::create($trans);

                Echo"Success";
                die();
            }
        }
    }
    public function kurver(Request $request)
    {
        $kur = Price::latest()->first();
        echo $kur->price;die();
    }
}
